#include <iostream>
#include <vector>
#include <set>

using namespace std;

int izracunaj_preseke(const vector<int>& niz) {
    int presek = 0;
    for (size_t i = 0; i + 1 < niz.size(); i++)
        if (niz[i] > niz[i + 1])
            presek++;
    return presek;
}

int azuriraj_preseke(vector<int>& niz, int presek, int a, int b) {
    int n = niz.size();
    set<int> pozicije;
    for (int x : {a - 1, a, b - 1, b}) {
        if (0 <= x && x < n - 1)
            pozicije.insert(x);
    }

    int stari = 0, x;
    for (int x : pozicije)
        if (niz[x] > niz[x + 1])
            stari++;

    swap(niz[a], niz[b]);

    int novi = 0;
    for (int x : pozicije)
        if (niz[x] > niz[x + 1])
            novi++;

    return presek - stari + novi;
}

int main() {
    cin.tie(nullptr);

    int n, q, i, j, presek;
    cin >> n >> q;
    vector<int> niz(n);
    for (i = 0; i < n; i++)
        cin >> niz[i];

    vector<pair<int, int>> upiti(q);
    for (int i = 0; i < q; i++)
        cin >> upiti[i].first >> upiti[i].second;

    vector<int> rezultati;
    presek = izracunaj_preseke(niz);
    rezultati.push_back(presek);

    for (const auto& par : upiti) {
        i = par.first;
        j = par.second;
        i--; j--;
        presek = azuriraj_preseke(niz, presek, i, j);
        rezultati.push_back(presek);
    }

    for (int rez : rezultati)
        cout << rez << "\n";

    return 0;
}